// tslint:disable:no-bitwise

import * as opcode from './opcode';
import { RequestIdFactory } from './request_id_factory';

const magic1: number = 'S'.charCodeAt(0);
const magic2: number = 't'.charCodeAt(0);
const version: number = 4;

export function set(data: Uint8Array, code: number, reqId: number): boolean {
  if (data.length < 6 || !opcode.isValid(code) || !RequestIdFactory.isValid(reqId)) {
    return false;
  }
  data[0] = magic1;
  data[1] = magic2;
  data[2] = version;
  data[3] = code;
  data[4] = (reqId & 0xFF00) >>> 8;
  data[5] = reqId & 0xFF;
  return true;
}

export function getCode(data: Uint8Array): number {
  if (data.length < 4 || data[0] !== magic1 || data[1] !== magic2 || data[2] !== version) {
    return opcode.Invalid;
  }
  return data[3];
}

export function getRequest(data: Uint8Array): number {
  if (data.length < 6) {
    return 0;
  }
  return (data[4] << 8) | data[5];
}
