// tslint:disable:no-bitwise
import { Address } from '../address';
import { Source } from '../source';
import * as utf8 from './utf8';

export function address(addr: Address, bytes: Uint8Array, offset: number): boolean {
  return utf8.marshal(addr.key, bytes, offset);
}

function uint32(value: number, bytes: Uint8Array, offset: number): boolean {
  value = Math.floor(value);
  if (value < 0 || value > 0xffffffff || bytes.length < offset + 4) {
    return false;
  }
  for (let i = offset + 3; i >= offset; --i) {
    bytes[i] = value & 0xff;
    value = value >>> 8;
    if (value === 0) {
      return true;
    }
  }
  return false;
}

export function source(value: Source | undefined, bytes: Uint8Array, offset: number): boolean {
  const id = value ? value.id : 0;
  return uint32(id, bytes, offset);
}

export function position(value: number, bytes: Uint8Array, offset: number): boolean {
  return uint32(value, bytes, offset);
}
