// tslint:disable:no-bitwise

const client: number = 1 << 6;
const service: number = 1 << 7;

export const Invalid: number = 0;

export const Init: number = client | 0;
export const Join: number = client | 1;
export const Part: number = client | 2;
// RIP List = 3
export const Send: number = client | 4;
export const Release: number = client | 5;
export const Refresh: number = client | 6;

export const Drain: number = service | 0;
export const Ack: number = service | 1;
export const Closed: number = service | 2;
export const Sent: number = service | 3;
export const Error: number = service | 4;
export const Lost: number = service | 5;
export const Expiring: number = service | 6;

export function isValid(code: number): boolean {
  return (code & client) === client || (code & service) === service;
}
