// tslint:disable:no-bitwise
const overflow: number = 1 << 16;

export class RequestIdFactory {
  public static isValid(id: number): boolean { return id > 0 && id < overflow; }

  private current: number = 1;
  public get next(): number {
    const out = this.current;
    this.current += 2;
    this.current %= overflow;
    return out;
  }
}
