
export class ResponseHandler<T> {
  public readonly promise: Promise<T>;
  private _resolve: (val: T) => void;
  private _reject: (val: Error) => void;
  private isBound: boolean = false;
  private isSet: boolean = false;
  constructor() {
    this.promise = new Promise((resolve, reject) => {
      this._resolve = resolve;
      this._reject = reject;
    });
  }

  public get resolved(): boolean { return this.isSet; }
  public get bound(): boolean { return this.isBound; }

  public bind(promise: Promise<T>): void {
    this.isBound = true;
    promise.then(this.resolve.bind(this), this.reject.bind(this));
  }

  public resolve(val: T): void {
    this.isSet = true;
    this._resolve(val);
  }

  public reject(err: Error): void {
    this.isSet = true;
    this._reject(err);
  }
}
