
const maxRetryTime = 15000;

// TODO : handle cross-node + browser setTimeout definition better
declare function setTimeout(callback: () => void, delay: number): any;

export class RetryLogic {
    private retryTime: number = 0;
    private lastAttempt?: Date;

    public schedule(task: () => void): void {
        const isRetry = this.lastAttempt && (new Date().getTime() - this.lastAttempt.getTime()) < maxRetryTime;
        const attemptDelay = isRetry ? this.retryTime : 0;
        this.retryTime = Math.min(2 * attemptDelay + 500, maxRetryTime - 500);

        const data = this;
        setTimeout(() => {
            data.lastAttempt = new Date();
            task();
        }, attemptDelay);
    }
}
