// tslint:disable:no-bitwise
import { Address } from '../address';
import { Segment } from '../segment';
import { Source } from '../source';
import * as utf8 from './utf8';

class SimpleSource implements Source {
  constructor(readonly id: number) {}
}

export function address(bytes: Uint8Array, offset: number): Address | undefined {
  const key = utf8.unmarshal(bytes, offset);
  return key ? Address.parse(key) : undefined;
}

function uint32(bytes: Uint8Array, offset: number): number | undefined {
  const end: number = offset + 4;
  let out = 0;
  if (bytes.length < end) {
    return undefined;
  }
  for (let i = offset; i < end; ++i) {
    out = (out << 8);
    out >>>= 0;
    out += bytes[i];
  }
  return out;
}

export function position(bytes: Uint8Array, offset: number): number | undefined {
  return uint32(bytes, offset);
}

export function source(bytes: Uint8Array, offset: number): Source | undefined {
  const id = position(bytes, offset);
  return id !== undefined ? new SimpleSource(id) : id;
}

export function segment(bytes: Uint8Array, offset: number): Segment | undefined {
  const start = position(bytes, offset);
  const end = position(bytes, offset + 4);
  if (start === undefined || end === undefined) {
    return undefined;
  }
  return new Segment(start, end);
}
