// NOTE : can't rely on TextEncoder because MS hasn't implemented it yet.

// TODO : correctly split multi-byte codes
export function byteLength(value: string): number {
  return value.length;
}

export function end(bytes: Uint8Array, offset: number): number | undefined {
  for (let i = offset; bytes.length > i; ++i) {
    if (bytes[i] === 0) {
      return i;
    }
  }
  return undefined;
}

export function marshal(value: string, bytes: Uint8Array, offset: number): boolean {
  if (value.length + offset > bytes.length) {
    return false;
  }
  for (const c of value) {
    if (offset === bytes.length) {
      return false;
    }
    bytes[offset] = c.charCodeAt(0);
    ++offset;
  }
  return true;
}

export function unmarshal(bytes: Uint8Array, offset: number): string | undefined {
  if (offset > bytes.length) {
    return undefined;
  }
  let stop = end(bytes, offset);
  if (stop === undefined) {
    stop = bytes.length;
  }
  return String.fromCodePoint(...bytes.slice(offset, stop));
}
