const { CleanWebpackPlugin } = require('clean-webpack-plugin');
const path = require('path');

module.exports = {
  entry: {
    lib: './src/index.ts'
  },
  output: {
    filename: 'index.js',
    path: path.resolve(__dirname, 'dist'),
    library: 'extension-messaging-prototype',
    libraryTarget: 'umd',
    umdNamedDefine: true,
    globalObject: `(typeof self !== 'undefined' ? self : this)`
  },
  devtool: 'source-map',
  resolve: {
    extensions: ['.ts','.js']
  },
  module: {
    rules: [{ test: /\.ts$/, use: 'ts-loader' }]
  },
  externals: {
    'axios': 'axios',
    'universal-websocket-client': 'universal-websocket-client',
  },
  plugins: [
    new CleanWebpackPlugin()
  ]
}
