# EML-loadtest-client

Client to do capacity testing on the [EML service](https://git-aws.internal.justin.tv/devhub/e2ml) by connecting and sending random messages.

## Configuration

The eml-lodtest service has static and dynamic configurations:

 * `FlagsEnvConfig`: static configuration through flags and environment variables.
 * `DynamicConfig`: dynamically update number of writers, listeners and other things. The eml-loadtest service checks every few seconds if something changed in that file and updates the running test accordingly.

## Run locally

The eml-loadtest is a go script, see available options with `-h`.

```sh
go run main.go -h
```

The options are for static configuration and can be specified both with flags or environment variables. The value for `--dynamicconfurl` is the address of the TOML file that can be updated while the test is running. Change that file to increase/decrease the number of listeners/writers.

## Run on AWS

The loadtest runs as an ECS Fargate service in the account `twitch-devhub-testing`.

 * The `/cdk-infra` folder describes the infra.
 * The `./scripts/` folder has commands to start, update and stop tests.
 * Infra task count is set to zero by default to avoid costs. Make sure to leave it back to zero when you are done testing.

For example, run a test with 20k users over 1k channels:

 * Update `/config/dynamic_config/dev01.toml` for writers, with `TaskCount = 1`, `Writers = 1000`, `Listeners = 1000` and `Addrs = 1000`. Make sure to keep as many listeners and channels as writers in the same process, so the metrics can report the average duration of each message.
 * Update `/config/dynamic_config/dev02.toml` for listeners, with `TaskCount = 2` (one single ECS task can handle around 10k listeners, we need two tasks for 20k), `Writers = 0`, `Listeners = 10000` and `Addrs = 1000`. That will round-robin 10k listeners over 1k channels, the same channels where the writers are sending messages from dev01.
 * Login with `mwinit` and `ada credentials`
 * `./scripts/run.sh dev01`; to push the config to S3, and set ECS number of dev01 tasks to TaskCount = 1.
 * `./scripts/run.sh dev02`; to push the config to S3, and set ECS number of dev02 tasks to TaskCount = 2.

When you are done running the test, you can either update the files with `TaskCount = 0`, or use the second parameter of the script to set tasks to zero:
 * `./scripts/run.sh dev01 0`; to set ECS number of dev01 tasks to zero.
 * `./scripts/run.sh dev02 0`; to set ECS number of dev01 tasks to zero.

## Docker build and push (update/deploy test)

Requirements:

 * Docker
 * awscli
 * Access to Isengard from the command line ([see more](https://wiki.twitch.com/display/AD/Using+Isengard+from+the+command+line+or+programatically)).

If there are new changes on the Go script or Dockerfile, build a new image:

```sh
make docker_build
```

Push latest image to ECR:

```sh
make docker_push
```

## Infra

See [cdk/README.md](cdk/README.md).
