import { IRepository, Repository } from '@aws-cdk/aws-ecr';
import { Construct, RemovalPolicy, Stack, StackProps } from '@aws-cdk/core';

export class EcrRepositoryStack extends Stack {
  public readonly ecrRepo: IRepository;

  constructor(scope: Construct, id: string, props: StackProps) {
    super(scope, id, props);

    const repo = new Repository(this, 'ECRRepo', {
      removalPolicy: RemovalPolicy.DESTROY,
    });
    repo.addLifecycleRule({ maxImageCount: 10 });
    this.ecrRepo = repo;
  }
}
