import ec2 = require('@aws-cdk/aws-ec2');
import ecs = require('@aws-cdk/aws-ecs');
import cdk = require('@aws-cdk/core');

interface ECSClusterStackProps extends cdk.StackProps {
    vpc: ec2.IVpc;
}

export class ECSClusterStack extends cdk.Stack {
  public cluster: ecs.Cluster;
  constructor(scope: cdk.Construct, id: string, props: ECSClusterStackProps) {
    super(scope, id, props);

    this.cluster = new ecs.Cluster(this, `Cluster`, {
      vpc: props.vpc,
    });
  }
}
