import { ISecret, Secret } from '@aws-cdk/aws-secretsmanager';
import { Construct, Stack, StackProps } from '@aws-cdk/core';

export class SecretsStack extends Stack {
  public readonly datadogApiKey: ISecret;
  public readonly devGreeterClientS2s: ISecret;
  public readonly prodGreeterClientS2s: ISecret;

  constructor(scope: Construct, id: string, props: StackProps) {
    super(scope, id, props);

    this.datadogApiKey = new Secret(this, 'DatadogSecret', { secretName: 'datadog-api-key' });
    this.devGreeterClientS2s = new Secret(this, 'DevSecret', { secretName: 'dev-greeter-client-s2s' });
    this.prodGreeterClientS2s = new Secret(this, 'ProdSecret', { secretName: 'prod-greeter-client-s2s' });
  }
}
