package emlclient

import (
	"net/url"
	"time"

	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/discovery/broker/deferred"
	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/metrics"
	"code.justin.tv/devhub/e2ml/libs/session"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/registry"
)

const timeout = 2 * time.Second

type RegistryFactory interface {
	Create() stream.Registry
}

type registryFactory struct {
	auth       stream.AuthSource
	broker     discovery.Broker
	wssFactory session.ClientResolver
	tracker    metrics.Tracker
	logger     logging.Function
}

func NewRegistryFactory(url *url.URL, wssFactory session.ClientResolver, auth stream.AuthSource, logger logging.Function, tracker metrics.Tracker) RegistryFactory {
	return &registryFactory{
		auth:       auth,
		broker:     deferred.NewBroker(url),
		wssFactory: wssFactory,
		logger:     logger,
		tracker:    tracker,
	}
}

func (r *registryFactory) Create() stream.Registry {
	return registry.NewRemote(r.auth, r.broker, r.wssFactory, timeout, r.tracker, r.logger)
}
