#!/bin/bash
set -e

# Check Task Count of loadtest services

export AWS_DEFAULT_REGION="us-west-2"
export AWS_PROFILE="twitch-devhub-testing"
export AWS_ACCOUNT="947140302170"

CLUSTER="EMLLoadtestECSCluster-ClusterEB0386A7-ITAKACQ5L4QK"
SERVICES="eml_loadtest_dev01 eml_loadtest_dev02 eml_loadtest_dev03 eml_loadtest_dev04"

echo "ada credentials (make sure to be on the Amazon VPN and run mwinit first)"
ada credentials update --once --provider=isengard --role=admin --profile=$AWS_PROFILE --account=$AWS_ACCOUNT

# Check if jq is available
command -v jq >/dev/null 2>&1 || { echo "jq is required. Please install (brew install jq)" >&2; exit 1; }

echo ">> aws ecs describe-services --cluster=$CLUSTER --services $SERVICES"
aws ecs describe-services --cluster=$CLUSTER --services $SERVICES | jq \
	'{services: [.services[] | {serviceName, runningCount, desiredCount}], failures}'
