#!/bin/bash
set -e

# Push the image to ECR: https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-push-ecr-image.html

export AWS_DEFAULT_REGION="us-west-2"
export AWS_PROFILE="twitch-devhub-testing"
export AWS_ACCOUNT="947140302170"
ECR_REPO="emllo-ecrre-px0soeosyxj0" # the name of the ECR repository is auto-generated by CDK

echo ">> ada credentials (make sure to be on the Amazon VPN and run mwinit first)"
ada credentials update --once --provider=isengard --role=admin --profile=$AWS_PROFILE --account=$AWS_ACCOUNT

echo ">> Get Docker image id, assuming that it was built with docker build -t eml_loadtest ."
DOCKER_IMAGE_ID=`docker images eml_loadtest:latest --format "{{.ID}}"`
if [ -z "$DOCKER_IMAGE_ID" ]; then
    echo "docker images eml_loadtest:latest did not return any result. Please, make sure to do first: docker build -t eml_loadtest ."
    exit 1
fi
echo "DOCKER_IMAGE_ID=$DOCKER_IMAGE_ID"

echo ">> Get and run docker login command to authenticate your Docker CLI to the ECR registry"
aws ecr get-login-password ${REGION} | docker login --username AWS --password-stdin ${AWS_ACCOUNT}.dkr.ecr.us-west-2.amazonaws.com

echo ">> Tag image with the Amazon ECR registry"
ECR_REGISTRY_TAG=$AWS_ACCOUNT.dkr.ecr.us-west-2.amazonaws.com/$ECR_REPO:latest
docker tag $DOCKER_IMAGE_ID $ECR_REGISTRY_TAG

echo ""
echo "docker push $ECR_REGISTRY_TAG"
docker push $ECR_REGISTRY_TAG
