package broker

import (
	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/promise"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type asyncScopesPromise struct {
	src promise.MutableAny
}

func NewAsyncScopesPromise() discovery.MutableScopesPromise {
	return &asyncScopesPromise{promise.NewAny()}
}

func (a *asyncScopesPromise) WouldBlock() bool          { return a.src.WouldBlock() }
func (a *asyncScopesPromise) Get() (interface{}, error) { return a.src.Get() }
func (a *asyncScopesPromise) Result() (stream.AddressScopes, error) {
	result, err := a.src.Get()
	if cast, ok := result.(stream.AddressScopes); ok || result == nil {
		return cast, err
	}
	return nil, protocol.ErrInvalidCacheEntry
}

func (a *asyncScopesPromise) Set(scopes stream.AddressScopes, err error) {
	a.src.Set(scopes, err)
}
