package broker

import (
	"sync"

	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
)

type IndirectTicketPromise interface {
	discovery.TicketPromise
	Set(discovery.TicketPromise) discovery.TicketPromise
}

type indirectTicketPromise struct {
	src discovery.TicketPromise
	w   sync.WaitGroup
}

func NewIndirectTicketPromise() IndirectTicketPromise {
	promise := &indirectTicketPromise{}
	promise.w.Add(1)
	return promise
}

func (i *indirectTicketPromise) WouldBlock() bool          { return i.src == nil || i.src.WouldBlock() }
func (i *indirectTicketPromise) Get() (interface{}, error) { return i.Result() }
func (i *indirectTicketPromise) Result() (discovery.Ticket, error) {
	i.w.Wait()
	result, err := i.src.Get()
	if cast, ok := result.(discovery.Ticket); ok {
		return cast, err
	}
	return nil, protocol.ErrInvalidCacheEntry
}
func (i *indirectTicketPromise) Set(ticket discovery.TicketPromise) discovery.TicketPromise {
	if i.src == nil {
		if ticket == nil {
			i.src = NewStaticTicketPromise(nil, protocol.ErrInvalidCacheEntry)
		} else {
			i.src = ticket
		}
		i.w.Done()
	}
	return i
}
