package broker

import (
	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type staticScopesPromise struct {
	scopes stream.AddressScopes
	err    error
}

func NewStaticScopesPromise(scopes stream.AddressScopes, err error) discovery.ScopesPromise {
	return &staticScopesPromise{scopes, err}
}

func (s *staticScopesPromise) WouldBlock() bool                      { return false }
func (s *staticScopesPromise) Result() (stream.AddressScopes, error) { return s.scopes, s.err }
func (s *staticScopesPromise) Get() (interface{}, error)             { return s.scopes, s.err }
