package broker

import (
	"code.justin.tv/devhub/e2ml/libs/discovery"
)

type staticTicketPromise struct {
	ticket discovery.Ticket
	err    error
}

func NewStaticTicketPromise(ticket discovery.Ticket, err error) discovery.TicketPromise {
	return &staticTicketPromise{ticket, err}
}

func (s *staticTicketPromise) WouldBlock() bool                  { return false }
func (s *staticTicketPromise) Result() (discovery.Ticket, error) { return s.ticket, s.err }
func (s *staticTicketPromise) Get() (interface{}, error)         { return s.ticket, s.err }
