package discovery

import (
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/ticket"
)

// HostReporter supplies a method for a host to forward its information to
// brokers so that they can perform routing and balancing
type HostReporter interface {
	ticket.Redeemer

	SetSourceLogic(SourceLogic)

	// TODO : return promises
	AddSupported(scopes stream.AddressSourceMap)
	DropSupported(scopes stream.AddressSourceMap)
	UpdateStatus(load protocol.LoadFactor, flags protocol.StatusFlags)
	Tick()
	Close() error
}
