package protocol

import "net/http"

const (
	HttpVersion1Pattern    = "/v1/*"
	HttpCurrentVersionPath = "/v1"
)

const (
	GetHostMethod       = http.MethodGet
	GetHostPath         = "/host"
	GetHostAddressParam = "address"
	ClientIDHeader      = "client-id"
	AuthorizationHeader = "authorization"
	AuthorizationPrefix = "Bearer "
)

type AuthorizationSource func(http.Header) (http.Header, error)
