package protocol

// Message is the base unit of communication for this protocol
type Message interface {
	OpCode() OpCode
	Marshal(ver Version) ([]byte, error)
	Unmarshal(ver Version, bytes []byte) error
	String() string
}

// used when a host wants to tell discovery something
type Ackable interface {
	Message
	AckID() AckID
}

// used when discovery wants a host to do something
type Request interface {
	Message
	RequestID() RequestID
}

// used by host to respond to discovery requests
type Response interface {
	Message
	ForRequestID() RequestID
}
