package discovery

import (
	"code.justin.tv/devhub/e2ml/libs/promise"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type Ticket interface {
	URL() string
	Method() stream.AuthMethod
	AccessCode() stream.OpaqueBytes
	Scopes() stream.AddressScopes
}

type TicketPromise interface {
	promise.Any
	Result() (Ticket, error)
}

type MutableTicketPromise interface {
	TicketPromise
	Set(Ticket, error)
}
