package errors

import "encoding/json"

type badMarshal struct{}

func (*badMarshal) MarshalJSON() ([]byte, error) { return nil, NewBuilder("expected").Build() }

func MarshalAny(err error) ([]byte, error) {
	return json.Marshal(extract(err))
}

func UnmarshalAny(data []byte, result *error) error {
	value := &errorImpl{}
	if err := json.Unmarshal(data, value); err != nil {
		return err
	}
	*result = value.wrap()
	return nil
}
