package datadog

import (
	"math"
	"sync/atomic"
)

type aggregator struct {
	name    string
	tags    []string
	tracker *tracker
	value   uint64
}

func (a *aggregator) Add(value int64) {
	for {
		prev := atomic.LoadUint64(&a.value)
		calc := math.Float64frombits(prev) + float64(value)
		if atomic.CompareAndSwapUint64(&a.value, prev, math.Float64bits(calc)) {
			a.send(calc)
			return
		}
	}
}

func (a *aggregator) Set(value float64) {
	atomic.StoreUint64(&a.value, math.Float64bits(value))
	a.send(value)
}

func (a *aggregator) tick() {
	a.send(math.Float64frombits(atomic.LoadUint64(&a.value)))
}

func (a *aggregator) send(value float64) {
	a.tracker.client.Gauge(a.name, value, a.tags, 1)
}
