package datadog

import "sync/atomic"

type count struct {
	name    string
	tags    []string
	tracker *tracker
	value   int64
}

func (c *count) Add(value int64) { atomic.AddInt64(&c.value, value) }

func (c *count) tick() {
	if value := atomic.SwapInt64(&c.value, 0); value != 0 {
		c.tracker.client.Count(c.name, value, c.tags, 1)
	}
}
