package datadog

import (
	"math"
	"sync/atomic"
)

type gauge struct {
	name    string
	tags    []string
	tracker *tracker
	value   uint64
}

func (g *gauge) Set(value float64) {
	atomic.StoreUint64(&g.value, math.Float64bits(value))
	g.tracker.client.Gauge(g.name, value, g.tags, 1)
}

func (g *gauge) tick() {
	g.tracker.client.Gauge(g.name, math.Float64frombits(atomic.LoadUint64(&g.value)), g.tags, 1)
}
