package logged

import "sync/atomic"

type count struct {
	k     string
	id    string
	value int64
}

func (c *count) Add(value int64) { atomic.AddInt64(&c.value, value) }

func (c *count) key() string { return c.k }

func (c *count) tick() (string, float64, bool) {
	if value := atomic.SwapInt64(&c.value, 0); value != 0 {
		return c.id, float64(value), true
	}
	return "", 0, false
}
