package logged

import (
	"math"
	"sync/atomic"
)

type gauge struct {
	k     string
	id    string
	value uint64
	prev  uint64
}

func (g *gauge) Set(value float64) {
	atomic.StoreUint64(&g.value, math.Float64bits(value))
}

func (g *gauge) key() string { return g.k }

func (g *gauge) tick() (string, float64, bool) {
	value := atomic.LoadUint64(&g.value)
	if prev := atomic.SwapUint64(&g.prev, value); prev != value {
		return g.id, math.Float64frombits(value), true
	}
	return "", 0, false
}
