package logged

import "sort"

type metric interface {
	tick() (string, float64, bool)
	key() string
}

type metricList []metric

var _ sort.Interface = (metricList)(nil)

func (m metricList) Len() int           { return len(m) }
func (m metricList) Less(i, j int) bool { return m[i].key() < m[j].key() }
func (m metricList) Swap(i, j int)      { m[i], m[j] = m[j], m[i] }
