package promise

type Bool interface {
	Any
	Result() (bool, error)
}

type MutableBool interface {
	Bool
	Set(bool, error)
}

func NewBool() MutableBool {
	return &asyncBool{src: NewAny()}
}

func NewSyncBool(success bool, err error) Bool {
	return &syncBool{success, err}
}

type syncBool struct {
	success bool
	err     error
}

func (s *syncBool) WouldBlock() bool          { return false }
func (s *syncBool) Get() (interface{}, error) { return s.success, s.err }
func (s *syncBool) Result() (bool, error)     { return s.success, s.err }

type asyncBool struct {
	src MutableAny
}

func (a *asyncBool) WouldBlock() bool          { return a.src.WouldBlock() }
func (a *asyncBool) Get() (interface{}, error) { return a.src.Get() }
func (a *asyncBool) Result() (bool, error) {
	result, err := a.src.Get()
	cast, ok := result.(bool)
	return ok && cast, err
}

func (a *asyncBool) Set(result bool, err error) {
	a.src.Set(result, err)
}
