package auth

import (
	"code.justin.tv/devhub/e2ml/libs/stream"
)

// Decoder validates an auth token for the given method and
// converts it back into the AuthRequest that generated it.
// It is designed to support multiple auth methods by returning a boolean
// on successful match of conditions.
type Decoder interface {
	Method() string
	Decode(token stream.OpaqueBytes) (stream.AuthRequest, bool)
}
