package empty

import (
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

type decoder struct{}

var dec = &decoder{}

// NewExtractor returns a an extractor that succeeds if no Authorization header
// is found, allowing anonymous access. If any Authorization header is found,
// this method rejects it as invalid, allowing this Extractor to be chained
// with other methods.
func NewDecoder() auth.Decoder {
	return dec
}

func (*decoder) Method() string { return method }
func (*decoder) Decode(code stream.OpaqueBytes) (stream.AuthRequest, bool) {
	if code.IsEmpty() {
		return req, true
	}
	return nil, false
}
