package empty

import (
	"net/http"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
)

const method = "empty"

type extractor struct{}

var ext = &extractor{}

// NewExtractor returns a an extractor that succeeds if no Authorization header
// is found, allowing anonymous access. If any Authorization header is found,
// this method rejects it as invalid, allowing this Extractor to be chained
// with other methods.
func NewExtractor() auth.Extractor {
	return ext
}

func (*extractor) Method() string { return method }
func (*extractor) FailureReason(header http.Header) error {
	if header.Get(protocol.HTTPAuthorizationHeader) != "" {
		return stream.ErrExpectedAnonymousRequest
	}
	return nil
}

func (*extractor) Extract(header http.Header) (stream.AuthRequest, bool) {
	if header.Get(protocol.HTTPAuthorizationHeader) != "" {
		return nil, false
	}
	return req, true
}
