package auth

import (
	"code.justin.tv/devhub/e2ml/libs/stream"
)

// Reader combines a Decoder and a Resolver and allows a single Read() call on string tokens.
type Reader struct {
	d Decoder
	r Resolver
}

var _ Resolver = (*Reader)(nil)
var _ Decoder = (*Reader)(nil)

func NewReader(d Decoder, r Resolver) *Reader {
	return &Reader{d, r}
}

func (r *Reader) Read(token stream.OpaqueBytes) (stream.Credentials, error) {
	if req, ok := r.Decode(token); ok {
		return r.Resolve(req)
	}
	return nil, stream.ErrInvalidAuthMethod
}

func (r *Reader) Method() string { return r.r.Method() }
func (r *Reader) Decode(token stream.OpaqueBytes) (stream.AuthRequest, bool) {
	return r.d.Decode(token)
}
func (r *Reader) Resolve(req stream.AuthRequest) (stream.Credentials, error) { return r.r.Resolve(req) }
