package s2s

import (
	"code.justin.tv/common/jwt"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

type decoder struct{}

var decSingleton = &decoder{}

func NewDecoder() auth.Decoder { return decSingleton }

func (d *decoder) Method() string { return s2sMethod }

func (d *decoder) Decode(encodedJWTStr OpaqueBytes) (stream.AuthRequest, bool) {
	encodedJWT := []byte(encodedJWTStr)
	jwtParts, err := jwt.Parse(encodedJWT)
	if err != nil {
		return nil, false // not a valid JWT
	}

	return &request{
		encodedJWT: encodedJWT,
		parsedJWT:  &jwtParts,
	}, true
}
