package stream

import (
	"net/http"
)

// An AuthRequest represents a colletion of raw data required to generate
// Credentials for use of stream libraries. It should be passed to a Broker
// when attempting to FindHost so that proper security decisions can be made
// based on the permissions in the resulting credentials.
type AuthRequest interface {
	Method() string
	Encode() OpaqueBytes
	Inject(http.Header) (http.Header, error)
}

// An AuthSource returns the latest AuthRequest on demand
type AuthSource func() AuthRequest
