package stream

import (
	"code.justin.tv/devhub/e2ml/libs/promise"
)

type CredentialsPromise interface {
	promise.Any
	Result() (Credentials, error)
}

type MutableCredentialsPromise interface {
	CredentialsPromise
	Set(Credentials, error)
}

func NewCredentialsPromise() MutableCredentialsPromise {
	return &asyncCredentials{src: promise.NewAny()}
}

func NewSyncCredentialsPromise(result Credentials, err error) CredentialsPromise {
	return &syncCredentials{result, err}
}

type syncCredentials struct {
	result Credentials
	err    error
}

func (s *syncCredentials) WouldBlock() bool             { return false }
func (s *syncCredentials) Get() (interface{}, error)    { return s.result, s.err }
func (s *syncCredentials) Result() (Credentials, error) { return s.result, s.err }

type asyncCredentials struct {
	src promise.MutableAny
}

func (a *asyncCredentials) WouldBlock() bool          { return a.src.WouldBlock() }
func (a *asyncCredentials) Get() (interface{}, error) { return a.src.Get() }
func (a *asyncCredentials) Result() (Credentials, error) {
	result, err := a.src.Get()
	if cast, ok := result.(Credentials); ok {
		return cast, err
	}
	return nil, err
}

func (a *asyncCredentials) Set(result Credentials, err error) {
	a.src.Set(result, err)
}
