package stream

// A History encapsulates a storage strategy for a given stream address, allowing
// clean separation of listener management from message tracking. See the history
// subpackage for different strategies that each have their own tradeoffs.
type History interface {
	Address() Address
	// It is the responsibility of the history to debounce repeat or out-of-order
	// messages.
	Write(Message) error
	// Next returns the next segment in the sequence. Management of any gaps
	// between returns due to underlying data updates are the responsibility of
	// the caller (this interface does not report missing Segments).
	Next(SourceID, Position) (Message, bool)
	// Last returns the last position written to the history; only eventual
	// consisency is required.
	Last() (SourceID, Position)
	// Close marks the history closed, clearing resources and causing a reset of
	// the position counter.
	Close() error
}
