package history

import (
	"sync/atomic"
	"unsafe"

	"code.justin.tv/devhub/e2ml/libs/stream"
)

type singleEntry struct {
	address stream.Address
	entry   unsafe.Pointer
}

func NewSingleEntry(address stream.Address) stream.History {
	return &singleEntry{address: address, entry: unsafe.Pointer(&initial)}
}

func (s *singleEntry) Address() stream.Address { return s.address }

func (s *singleEntry) Write(msg stream.Message) error {
	atomic.StorePointer(&s.entry, unsafe.Pointer(&msg))
	return nil
}

func (s *singleEntry) Close() error {
	atomic.StorePointer(&s.entry, unsafe.Pointer(&closed))
	return nil
}

func (s *singleEntry) Next(src stream.SourceID, pos stream.Position) (stream.Message, bool) {
	e := s.current()
	if src == e.Source() && pos >= e.At().End || e == closed {
		return nil, false
	}
	return e, true
}

func (s *singleEntry) Last() (stream.SourceID, stream.Position) {
	e := s.current()
	if e == closed {
		return stream.None, stream.Origin
	}
	return e.Source(), e.At().End
}

func (s *singleEntry) current() stream.Message {
	return *(*stream.Message)(atomic.LoadPointer(&s.entry))
}
