package stream

// A Listener is fed stream segments or notifications that they have gone
// missing. Each lost or received message should be tracked by the consumer to
// understand their position in the stream for resumption if connection is lost.
//
// It is always safe for a Listener to report Current() at the Origin when first
// constructed; this will cause a best effort attempt to provide a full history
// for the topic that may result in an initial data lost response indicating the
// size of the virtual gap in history.
//
// OnDataLost and OnDataReceived return false if the underlying listener did not
// receive the message, which allows the system to explicitly handle missed data
// with a retry or connection reset as appropriate.
//
// Listeners are designed to take an address as an input so that they can
// receive families of related data (e.g. I can subscribe to "n@1?id=123" and
// expect to receive "n@1?id=123&topic=foo" along with "n@1?id=123&topic=bar").
// When used this way, each concrete address should have independent position
// tracking.
type Listener interface {
	Current(addr Address) (SourceID, Position)
	OnDataLost(at MessageDescription) bool
	OnDataReceived(message Message) bool
	OnStreamClosed(addr Address, cause error) bool
}
