package stream

// Position represents a virtual position in an information stream; the meaning
// of the sequence numbers is up to the source of the stream and must increase
// monotonically. Examples could be total length of bytes sent or number of
// messages sent for a particular stream. In the event that a position would
// overflow, the source should rotate its SourceID and reset its stream position.
type Position uint32

const (
	// Origin represents the absoulute beginning of a message stream
	Origin Position = 0
	// Closed represents a listener that is no longer accepting messages; it will
	// always be higher than proposed segments, causing early out of values.
	Closed Position = ^Origin
)

func (p Position) AsDelta() Segment    { return Segment{p - 1, p} }
func (p Position) AsKeyFrame() Segment { return Segment{Origin, p} }
func (p Position) ToSegment(isDelta bool) Segment {
	if isDelta {
		return p.AsDelta()
	}
	return p.AsKeyFrame()
}
