package message

import (
	"fmt"

	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
)

const (
	drainLength = headerLength
)

type Drain interface {
	protocol.Message
}

type drainMessage struct{}

var drainSingleton = &drainMessage{}

func NewDrain() (Drain, error) { return drainSingleton, nil }

func (*drainMessage) OpCode() protocol.OpCode { return protocol.Drain }

func (d *drainMessage) Marshal(ver protocol.Version) ([]byte, error) {
	if !ver.IsValid() {
		return nil, protocol.ErrInvalidVersion
	}
	bytes := make([]byte, drainLength)
	injectHeader(bytes, ver, d.OpCode())
	return bytes, nil
}

func (*drainMessage) Unmarshal(ver protocol.Version, bytes []byte) error {
	if !ver.IsValid() {
		return protocol.ErrInvalidVersion
	}
	total := len(bytes)
	if total != drainLength {
		return protocol.ErrInvalidLength(drainLength, total)
	}
	return nil
}

func (d *drainMessage) String() string {
	return fmt.Sprintf("<%s>", d.OpCode())
}
