package message

import "encoding/hex"

// HexPrintedBytes is a convenience wrapper that changes how byte
// arrays print to logs through lazy eval (putting the encode into
// the log statement would force it to be executed even when not
// logged, which is prohibitively expensive)
type HexPrintedBytes []byte

func (h HexPrintedBytes) String() string { return hex.EncodeToString(h) }
