package message

import (
	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol/message/marshal"
)

func Unmarshal(bytes []byte) (protocol.Message, error) {
	ver, op, ok := extractHeader(bytes)
	if !ok {
		return nil, protocol.ErrInvalidHeader
	}
	if msg := createBlank(op); msg != nil {
		if err := msg.Unmarshal(ver, bytes); err != nil {
			return nil, err
		}
		return msg, nil
	}
	return nil, protocol.ErrInvalidOpCode
}

func createBlank(op protocol.OpCode) protocol.Message {
	switch op {
	case protocol.Ack:
		return &ackMessage{}
	case protocol.Closed:
		return &closedMessage{}
	case protocol.Drain:
		return &drainMessage{}
	case protocol.Error:
		return &errorMessage{}
	case protocol.Expiring:
		return &expiringMessage{}
	case protocol.Init:
		return &initMessage{}
	case protocol.Join:
		return &joinMessage{}
	case protocol.Lost:
		return &lostMessage{}
	case protocol.Move:
		return &moveMessage{}
	case protocol.Part:
		return &partMessage{}
	case protocol.Refresh:
		return &refreshMessage{}
	case protocol.Release:
		return &releaseMessage{}
	case protocol.Send:
		return &sendMessage{}
	case protocol.Sent:
		data := &sentData{}
		return &sentMessage{
			sentData: data,
			v4:       marshal.NewOnceCache(data.marshalForCache, protocol.Four),
			v5:       marshal.NewOnceCache(data.marshalForCache, protocol.Five),
		}
	}
	return nil
}
