package registry

import "code.justin.tv/devhub/e2ml/libs/promise"

type deferredBool struct {
	src promise.Bool
	and bool
}

func newDeferredBool(src promise.Bool, and bool) promise.Bool {
	return &deferredBool{src, and}
}

func (d *deferredBool) WouldBlock() bool          { return d.src.WouldBlock() }
func (d *deferredBool) Get() (interface{}, error) { return d.Result() }
func (d *deferredBool) Result() (bool, error) {
	result, err := d.src.Get()
	cast, ok := result.(bool)
	return ok && cast && d.and, err
}
