package registry

import (
	"sync"
	"sync/atomic"

	"code.justin.tv/devhub/e2ml/libs/stream"
)

type deferredMessage struct {
	content []byte
	isDelta bool
	result  stream.TrackerPromise
	isSet   int32
	wg      sync.WaitGroup
}

var _ stream.TrackerPromise = (*deferredMessage)(nil)

func newDeferredMessage(content []byte, isDelta bool) *deferredMessage {
	msg := &deferredMessage{content: content, isDelta: isDelta, result: nil}
	msg.wg.Add(1)
	return msg
}

func (d *deferredMessage) WouldBlock() bool {
	return atomic.LoadInt32(&d.isSet) == 0 || d.result.WouldBlock()
}
func (d *deferredMessage) Get() (interface{}, error) { return d.Result() }
func (d *deferredMessage) Result() (stream.Tracker, error) {
	d.wg.Wait()
	return d.result.Result()
}

func (d *deferredMessage) set(result stream.TrackerPromise) {
	d.result = result
	atomic.AddInt32(&d.isSet, 1)
	d.wg.Done()
}
