package scheduler

import (
	"code.justin.tv/devhub/lib-lifecycle/src/lifecycle"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type inline struct{}

var singleton = &inline{}

func NewInline() stream.Scheduler {
	return singleton
}

func (*inline) SetClosed(address stream.Address, cause error, listeners []stream.Listener) error {
	for _, listener := range listeners {
		listener.OnStreamClosed(address, cause)
	}
	return nil
}

func (*inline) Update(history stream.History, end stream.Position, listeners []stream.Listener) (int, error) {
	var result error
	total := 0
	for _, listener := range listeners {
		count, err := Update(history, end, listener)
		result = lifecycle.CombineErrors(result, err)
		total += count
	}
	return total, result
}
