package stream

// A ServerLogic implementation allows the generic service-side stream code for
// audience management and notification to be backed by arbitrary code, enabling
// reuse of common code across stream services and sources.
type ServerLogic interface {
	// amount of load the server has handled since last call
	LoadFactor() uint64

	OnAddressJoined(addr Address) error
	OnAddressParted(addr Address) error
	OnAddressRequested(addr Address) error
	OnAddressReleased(addr Address) error

	// Asynchronous, complete promise when finished.
	OnSendRequested(addr Address, data []byte, idDelta bool, receipt MutableTrackerPromise)

	// Allow per-server customization of data management
	GetHistory(addr Address) (History, error)

	// Allow proper cleanup of logic specific resources
	Shutdown() error
}
